<?php
// no direct access
/*
 * @package mod_pass2download.php - Password 2 Download Joomla! Module
 * @author Piotr Wołoszyn
 * @copyright Copyright (C) 2014 http://www.in-web.pl All Rights Reserved.
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @website http://www.in-web.pl
 */

defined('_JEXEC') or die('Restricted access');
?>

<div class="pass2download">
        <?php if ($access): ?>
        <p>
    <?php echo $params->get('prepend'); ?>
        </p>
        <div id="p2d_downloads">
            <p id="p2d_error" style="display: none; font-weight: bold; color: #E05353;"></p>
            <form class="p2d_form">
                <input type="password" value="" name="code" class="noSubmit" />
                <input type="hidden" value="<?php echo $module->title; ?>" name="modtit" />
                <button id="p2d_submit" type="button"><?php echo JText::_('P2D_SUBMIT'); ?></button>
                <img class="ajax-loader" src="<?php echo $img_path . "ajax-loader.gif" ?>">
            </form>
        </div>
        <p>
        <?php echo $params->get('append'); ?>
        </p>
    <?php else: ?>
        <p><?php echo JText::_('P2D_ERROR_4'); ?></p>
<?php endif; ?>	
</div>
<?php if ($access): ?>
    <script type="text/javascript">
        jQuery(document).ready(function($) {

            $('.noSubmit').keypress(function(e) {
                if (e.which == 13)
                    e.preventDefault();
            });

            $('#p2d_submit').click(function() {

                $('.ajax-loader').show();

                var data = $(this).parent('.p2d_form').serialize();

                $.ajax({
                    url: '<?php echo $ajax_path; ?>/get_downloads.php',
                    data: data,
                    type: 'POST',
                    async: false,
                    success: function(jdata) {

                        var jsondata = JSON.parse(jdata);

                        if (jsondata.success == '1') {

                            $("#p2d_error").html("").hide();
                            $("#p2d_downloads").html(jsondata.html);

                        } else {

                            if (!$("#p2d_error").is(":visible")) {

                                $("#p2d_error").html(jsondata.error);
                                $("#p2d_error").fadeIn();

                            } else {

                                $("#p2d_error").html(jsondata.error);
                                $("#p2d_error").fadeOut().fadeIn();

                            }

                        }

                        $('.ajax-loader').hide();

                    }
                });

            });

        });
    </script>
<?php endif; ?>