<?php

/*
 * @package mod_pass2download.php - Password 2 Download Joomla! Module
 * @author Piotr Wołoszyn
 * @copyright Copyright (C) 2014 http://www.in-web.pl All Rights Reserved.
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @website http://www.in-web.pl
 */

// Load Application
session_start();
define('_JEXEC', 1);
define('JPATH_BASE', "../../..");
define('DS', DIRECTORY_SEPARATOR);
require_once ( JPATH_BASE . DS . 'includes' . DS . 'defines.php' );
require_once ( JPATH_BASE . DS . 'includes' . DS . 'framework.php' );

$app = & JFactory::getApplication('site');
$app->initialise();

// Get language
$lang = & JFactory::getLanguage();
$lang->load('mod_pass2download', JPATH_BASE);

// Parse POST variables
$title = JRequest::getString('modtit');
$code = JRequest::getString('code');
// Import
jimport('joomla.application.module.helper');
jimport('joomla.html.parameter');

// Get user and his Access Rights
$user = JFactory::getUser();
$groups = implode(',', $user->getAuthorisedViewLevels());

// Retrieve Module

$db = JFactory::getDbo();

$query = $db->getQuery(true);
$query->select('m.id, m.title, m.module, m.position, m.content, m.showtitle, m.params');
$query->from('#__modules AS m');
$query->where('m.published = 1');
$query->where('m.module = ' . $db->Quote('mod_pass2download'));
$query->where('m.title = ' . $db->Quote($title));
$query->where('m.access IN (' . $groups . ')');
$db->setQuery($query);

$module = $db->loadObject();

// Build adequate json response

$json_response = array();

if (!is_null($module) && $module->title == $title) {

    $access = true;
    
    // Version check for Joomla
    if( version_compare( JVERSION, '3.0.0', 'ge' ) ) {
        $params = new JRegistry( json_decode( $module->params ) );
    } else {
        $params = new JParameter( $module->params );
    }      

    if ($params->get('only_registered')) {

        if ($user->guest)
            $access = false;
    }

    if ($access) {

        if (!empty($code) && $code == $params->get('code', false)) {

            if (!isset($_SESSION['p2d'])) {
                $_SESSION['p2d'] = array();
            }

            $_SESSION['p2d'][$title] = true;

            $downloads = array();

            for ($i = 0; $i <= 9; $i++) {

                $check = $params->get('durl' . $i, false);



                if (!empty($check)) {

                    $root = JURI::root();
                    $root = trim(str_replace("/modules/mod_pass2download/ajax", "", $root), "/");

                    $url = $root . "/modules/mod_pass2download/ajax/download.php?title=" . $title . "&d=durl" . $i;
                    $name = $params->get('dname' . $i, false) ? $params->get('dname' . $i) : $url;

                    $item = array('url' => $url, 'name' => $name);

                    array_push($downloads, $item);
                }
            }


            if (count($downloads) > 0) {

                switch ($params->get('render', 1)) {

                    case 1 :

                        $html = "<ul class=\"p2d-list\">";

                        foreach ($downloads as $item) {
                            $html .= "<li><a target=\"_blank\" href=\"" . $item['url'] . "\" title=\"" . $item['name'] . "\">" . $item['name'] . "</li>";
                        }

                        $html .= "</ul>";
                        break;

                    case 2 :

                        $html = "<ol class=\"p2d-list\">";

                        foreach ($downloads as $item) {
                            $html .= "<li><a target=\"_blank\" href=\"" . $item['url'] . "\" title=\"" . $item['name'] . "\">" . $item['name'] . "</li>";
                        }

                        $html .= "</ol>";
                        break;

                    case 3 :

                        foreach ($downloads as $item) {
                            $html .= "<div><a target=\"_blank\" href=\"" . $item['url'] . "\" title=\"" . $item['name'] . "\">" . $item['name'] . "</div>";
                        }

                        break;

                    case 4 :

                        foreach ($downloads as $item) {
                            $html .= "<p><a target=\"_blank\" href=\"" . $item['url'] . "\" title=\"" . $item['name'] . "\">" . $item['name'] . "</p>";
                        }

                        break;
                }
            } else {

                $html = "<p>" . JText::_('P2D_MSG_1') . "</p>";
            }

            $json_response['success'] = 1;
            $json_response['html'] = $html;
        } else {


            $json_response['success'] = 0;
            $json_response['error'] = JText::_('P2D_ERROR_1');
        }
    } else {

        $json_response['success'] = 0;
        $json_response['error'] = JText::_('P2D_ERROR_4');
    }
} else {

    $json_response['success'] = 0;
    $json_response['error'] = JText::_('P2D_ERROR_3');
}

echo json_encode($json_response);
